import { world, system } from "@minecraft/server";
import { ActionFormData } from "@minecraft/server-ui";


world.afterEvents.playerInteractWithEntity.subscribe(event => {
    const { player, target } = event;
    if (!target || target.typeId !== "hivehub:game_wars") return;

    game(player);
});


world.afterEvents.entityHitEntity.subscribe(event => {
    const { damagingEntity, hitEntity } = event;
    if (!(damagingEntity?.typeId === "minecraft:player")) return;
    if (!hitEntity || hitEntity.typeId !== "hivehub:game_wars") return;

    game(damagingEntity);
});

function game(player) {
	const over = world.getDimension("minecraft:overworld");
	player.playSound("random.pop2");
        new ActionFormData()
            .title("§lMINI GAMES")
            .body('Choose where you wanna Teleport!')
            .button('§l§bP§eV§bP\n§r§7[ Click to Teleport ]', "textures/ui/pvp")
            .button('§l§bTHE END\n§r§7[ Click to Teleport ]', "textures/ui/end")
            .button('§l§5Parkour\n§r§7[ Click to Teleport ]', "textures/ui/parkour")
            .button('§l§cBow§bWars\n§r§7[ Click to Teleport ]', "textures/items/bow_standby")
            .button('§l§dBlock§6Drop §l§c[BETA]\n§r§7[ Click to Teleport ]', "textures/ui/blockdrop")
            .button('§l§bSky§eWars\n§r§7[ Click to Teleport ]', "textures/ui/skywars")
            .button('§l§dBlock§bParty\n§l§c[Not Available]')
            .button('§g§lDeathRun\n§l§c[Not Available]')
            .button('§l§fGravity\n§l§c[Not Available]')
            .show(player).then(r => {
            	if (r.selection == 0) {
                over.runCommandAsync(`tp "${player.name}" -1000 32 1000`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
            }
                if (r.selection == 1) {
                    const end = world.getDimension("minecraft:the_end");
                      end.runCommandAsync(`tp "${player.name}" 18 63 0`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
                }
                if (r.selection == 2) {
                    over.runCommandAsync(`tp "${player.name}" -2000 5 -2000 facing -2000 5 -1999`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
                }
                if (r.selection == 3) {
                    over.runCommandAsync(`tp "${player.name}" -3000 5 3000 facing -2999 5 3000`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
                }
                if (r.selection == 4) {
                    over.runCommandAsync(`tp "${player.name}" 2000 5 -2000 facing 2000 5 -1999`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
                }
                if (r.selection == 5) {
                    over.runCommandAsync(`tp "${player.name}" 5000 44 5000 facing 5000 44 4999`).then(() => {
        system.runTimeout(() => {
            player.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            player.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            player.playSound("respawn_anchor.charge");
        }, 1); // delay by 1 tick (~50ms)
    });
                }
            })
    }